﻿// specdemo.cpp : 定义控制台应用程序的入口点。
//

#include "stdafx.h"

#include "libspectrometer.h"
#include "stdio.h"
#include "conio.h"

//包含库文件
#ifdef _MSC_VER
#pragma comment(lib, "libspectrometer.lib")
#endif

//请根据实际设备上的光谱像素点个数，来配置这个值
#define PIXEL_COUNT 2048

//波长数组
double wavelength[PIXEL_COUNT] = { 0 };

//光谱数值数组
double spectrum[PIXEL_COUNT] = { 0 };


int main()
{
	int err = 0;

	//打开所有已经连接的USB光谱仪,一般这个打开函数我们需要检测返回值
	//第一个参数0为将来扩展参数使用，没有含义，但请一定填写 0 ，不写0，会导致光谱仪打不开
	//返回值为1表示正常，返回值为0，表示有错误，
	//第2个表示错误代码，第2个参数err指明了返回的错误，
	//如果有错误err 不为0 一般需要检查:
	//1.驱动是否安装成功，在设备管理器中查看是否有spectrometer设备，驱动未安装则有感叹号
	//2.USB线是否连接正确，
	//3.设备指示绿灯是否在闪烁，【注意正常工作是绿灯闪烁】，若设备绿灯不亮，或者常亮，表明设备不正常，需要插拔USB重启
	//返回值为1表示底层已处理此命令，并且参数正确，返回值为0，表示有错误，如参数错误，或者当前设备正忙在采集中，无法执行用户命令
	//////////////////////////////////////////////////////////
	//必须要注意，通常在visual studio调试中，开发者会点击暂停调试按钮，如果当前光谱数据正通过USB传输，暂停调试会导致
	//光谱设备死机，这个是正常现象，不使用visual studio调试设备时，不会出现死机问题
	//如何判断设备死机？光谱设备上绿色指示灯闪烁，则表示设备运行正常
	//////////////////////////////////////////////////////////
	if(libspectrometer_open_all_spectrometers(0, &err) == 0)
		return 0;

	//设置曝光时间
	//第1个参数0表示默认的第一台光谱设备，1表示第二台设备
	//第2个表示错误代码
	//第3个参数，设置曝光时间10ms,注意单位是us微秒，一般我们设置的是毫秒，需要乘以1000，数字后加L是为了告诉编译器这个值是一个long类型
	//如果同时连接多台光谱仪，则这里需要写光谱仪的index号，index号从0到size-1
	//如，我们有2台设备同时连接，0表示第一台设备，1表示第二台设备
	//注意，如果有多台设备，每次光谱仪插在不同的电脑的USB口上，枚举出来的顺序可能不一样，需要用户自行根据serial number来判断实际连接的设备
	//返回值为1表示底层已处理此命令，并且参数正确，返回值为0，表示有错误，如参数错误，或者当前设备正忙在采集中，无法执行用户命令
	libspectrometer_set_integration_time_microsec(0, &err, 10*1000L);


	//读取光谱仪的波长范围
	//第1个参数0，表示默认的第一台光谱设备，1表示第二台设备
	//第2个表示错误代码
	//第3个参数是一个double数组，用户需要在自己的应用中分配内存，和释放内存
	//第4个参数，告诉底层libspectrometer，wavelength数组有多大，避免底层复制的时候数组越界
	//返回值为1表示底层已处理此命令，并且参数正确，返回值为0，表示有错误，如参数错误，或者当前设备正忙在采集中，无法执行用户命令
	libspectrometer_get_wavelengths(0, &err, wavelength, PIXEL_COUNT);

	//设置平均次数，也就是每次光谱仪发起采集指令，光谱仪会自动采集10次，然后硬件自动做平均，仅仅返回平均后的结果
	//第1个参数0，表示默认的第一台光谱设备，1表示第二台设备
	//第2个表示错误代码
	//第3个参数就是平均次数，每次光谱设备上电后，平均次数被设置为1
	//返回值为1表示底层已处理此命令，并且参数正确，返回值为0，表示有错误，如参数错误，或者当前设备正忙在采集中，无法执行用户命令
	libspectrometer_set_average(0, &err, 10);


	//循环读10次光谱
	for (int i = 0; i < 10; i++)
	{
		//读取平均后的光谱数据，这是一个阻塞式的访问，也就是说 10ms * 10 = 0.1s 后才会有返回结果
	
		//第1个参数0，表示默认的第一台光谱设备，1表示第二台设备
		//第2个表示错误代码
		//第3个参数是一个double数组，用户需要在自己的应用中分配内存，和释放内存
		//第4个参数，告诉底层libspectrometer，spectrum数组有多大，避免底层复制的时候数组越界
		//返回值为1表示底层已处理此命令，并且参数正确，返回值为0，表示有错误，如参数错误，或者当前设备正忙在采集中，无法执行用户命令
		
		//关于曝光时间的取消，在普通软件触发模式下，无法中断曝光过程，
		//因为底层函数是阻塞式访问，无法取消
		libspectrometer_get_raw_spectrum(0, &err, spectrum, PIXEL_COUNT);

		//打印第100像素的光谱count值
		printf("Pixel 100 is %f\n", spectrum[100]);
	}


	//关闭所有USB光谱仪
	//关闭前请确保，当前设备不在采集中，否则会导致USB设备通讯异常，可能需要重启USB
	libspectrometer_close_all_spectrometers(&err);

	//等待用户按键后退出程序
	_getch();


    return 0;
}

